// /////////////////////////////////////////////////////////////
// File: KeyboardHookExt.cs	Class: Kennedy.ManagedHooks.KeyboardHookExt
// Date: 2/25/2004			Author: Michael Kennedy
// Language: C#				Framework: .NET
//
// Copyright: Copyright (c) Michael Kennedy, 2004-2005
// /////////////////////////////////////////////////////////////
// License: See License.txt file included with application.
// Description: See compiled documentation (Managed Hooks.chm)
// /////////////////////////////////////////////////////////////

using System;
using System.Windows.Forms;

namespace Managed_Hook
{
	public class KeyboardHookExt : KeyboardHook
	{
		public delegate void KeyboardEventHandlerExt(Keys key);

		public event KeyboardEventHandlerExt KeyDown;
		public event KeyboardEventHandlerExt KeyUp;
		public event KeyboardEventHandlerExt SystemKeyDown;
		public event KeyboardEventHandlerExt SystemKeyUp;

		public KeyboardHookExt()
		{
			this.KeyboardEvent += new KeyboardEventHandler(KeyboardHookExt_KeyboardEvent);
		}

		private void KeyboardHookExt_KeyboardEvent(KeyboardEvents kEvent, Keys key)
		{
			switch (kEvent)
			{
				case KeyboardEvents.KeyDown:
					OnKeyDown(key);
					break;
				case KeyboardEvents.KeyUp:
					OnKeyUp(key);
					break;
				case KeyboardEvents.SystemKeyDown:
					OnSysKeyDown(key);
					break;
				case KeyboardEvents.SystemKeyUp:
					OnSysKeyUp(key);
					break;
			}
		}

		protected virtual void OnKeyDown(Keys key)
		{
			Fire_KeyDown(key);
		}

		protected virtual void OnKeyUp(Keys key)
		{
			Fire_KeyUp(key);
		}

		protected virtual void OnSysKeyDown(Keys key)
		{
			Fire_SystemKeyDown(key);
		}

		protected virtual void OnSysKeyUp(Keys key)
		{
			Fire_SystemKeyUp(key);
		}

		private void Fire_KeyDown(Keys key)
		{
			if (KeyDown != null)
			{
				KeyDown(key);
			}
		}

		private void Fire_KeyUp(Keys key)
		{
			if (KeyUp != null)
			{
				KeyUp(key);
			}
		}

		private void Fire_SystemKeyDown(Keys key)
		{
			if (SystemKeyDown != null)
			{
				SystemKeyDown(key);
			}
		}

		private void Fire_SystemKeyUp(Keys key)
		{
			if (SystemKeyUp != null)
			{
				SystemKeyUp(key);
			}
		}

	}
}
